/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool.wizards;

import com.freescale.mfgtool.Messages;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.filesystem.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class MfgToolImportWizardPage
extends WizardPage
implements IOverwriteQuery {
    protected static String profileName = null;
    protected static String location = null;
    protected boolean profileNameSetByUser = false;
    protected Text profileNameTextField;
    protected Text text;
    private FileSystemStructureProvider structureProvider = new FileSystemStructureProvider();
    private String errorMessage = null;

    protected MfgToolImportWizardPage() {
        super(Messages.MfgToolImportWizard_PageName, Messages.MfgToolImportWizard_PageTitle, null);
        this.setDescription(Messages.MfgToolImportWizard_PageDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.file_system_import_wizard_page");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createNameWidgets(composite);
        this.createLocationWidgets(composite);
        this.setControl((Control)composite);
    }

    private void createLocationWidgets(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.MfgToolImportWizardPage_LocationLabel);
        group.setToolTipText(Messages.MfgToolImportWizardPage_ProfileToolTip);
        this.text = new Text((Composite)group, 2052);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setToolTipText(Messages.MfgToolImportWizardPage_ProfileToolTip);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String str = MfgToolImportWizardPage.this.text.getText();
                if (str != null) {
                    location = str;
                    if (MfgToolImportWizardPage.this.validateLocation()) {
                        MfgToolImportWizardPage.this.updateProfileName();
                    }
                }
                MfgToolImportWizardPage.this.setPageComplete(MfgToolImportWizardPage.this.validatePage());
            }
        });
        Button browse = new Button((Composite)group, 8);
        browse.setSize(75, 23);
        browse.setText(Messages.MfgToolImportWizardPage_Browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String directory = null;
                String currentLocation = MfgToolImportWizardPage.this.text.getText();
                if (currentLocation != null && !currentLocation.isEmpty()) {
                    File file = new File(currentLocation);
                    directory = file.isFile() ? file.getParent() : currentLocation;
                }
                DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 69632);
                dialog.setText(Messages.MfgToolImportWizardPage_BrowserTitle);
                dialog.setFilterPath(directory);
                String dirChosen = dialog.open();
                if (dirChosen != null) {
                    MfgToolImportWizardPage.this.text.setText(dirChosen);
                }
            }
        });
    }

    private void createNameWidgets(Composite composite) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText(Messages.MfgToolImportWizardPage_NameField);
        group.setToolTipText(Messages.MfgToolImportWizardPage_NameToolTip);
        this.profileNameTextField = new Text((Composite)group, 2052);
        this.profileNameTextField.setLayoutData((Object)new GridData(4, 4, true, true));
        this.profileNameTextField.setToolTipText(Messages.MfgToolImportWizardPage_NameToolTip);
        this.profileNameTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String str = MfgToolImportWizardPage.this.profileNameTextField.getText();
                if (str != null) {
                    profileName = str;
                    if (str.isEmpty()) {
                        MfgToolImportWizardPage.this.profileNameSetByUser = false;
                    }
                }
                MfgToolImportWizardPage.this.setPageComplete(MfgToolImportWizardPage.this.validatePage());
            }
        });
        this.profileNameTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MfgToolImportWizardPage.this.profileNameSetByUser = true;
            }
        });
    }

    protected void updateProfileName() {
        File file = new File(location);
        String name = file.getName();
        if (name.equals(profileName)) {
            return;
        }
        if (!this.profileNameSetByUser) {
            this.profileNameTextField.setText(name);
        }
    }

    public boolean finish() {
        int ind;
        String tmp = location;
        if (tmp.endsWith(Messages.MfgToolImportWizardPage_DefaultProfileName) && (ind = tmp.lastIndexOf(String.valueOf(File.separator) + Messages.MfgToolImportWizardPage_DefaultProfileName)) != -1) {
            tmp = tmp.substring(0, ind);
        }
        File source = new File(tmp);
        File[] listOfFiles = source.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(Messages.General_DefaultProfileName) || name.contains(Messages.General_ConfigFile) || name.endsWith(".log");
            }
        });
        ImportOperation operation = new ImportOperation((IPath)new Path("/" + profileName), (Object)source, (IImportStructureProvider)this.structureProvider, (IOverwriteQuery)this, Arrays.asList(listOfFiles));
        operation.setContext(this.getShell());
        operation.setCreateLinks(true);
        operation.setCreateContainerStructure(false);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            MessageDialog.open((int)1, (Shell)this.getShell(), (String)Messages.MfgToolImportWizardPage_InternalError, (String)NLS.bind((String)Messages.MfgToolImportWizardPage_ErrorDuringOperation, (Object)e.getCause()), (int)0x10000000);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        IStatus status = operation.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.MfgToolImportWizardPage_ImportError, (String)status.getMessage(), (IStatus)status);
            return false;
        }
        return true;
    }

    protected boolean validateLocation() {
        boolean isValid = false;
        if (location == null) {
            this.errorMessage = Messages.MfgToolImportWizardPage_NonExistentPath;
        } else if (location.isEmpty()) {
            this.errorMessage = Messages.MfgToolImportWizardPage_NonExistentPath;
        } else {
            File folder = new File(location);
            if (!folder.exists()) {
                this.errorMessage = Messages.MfgToolImportWizardPage_NonExistentPath;
            } else {
                File[] files = folder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(Messages.General_DefaultProfileName);
                    }
                });
                this.errorMessage = Messages.MfgToolImportWizardPage_InvalidDirectory;
                if (files.length > 0) {
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].exists() && files[i].isDirectory()) {
                            this.errorMessage = null;
                            isValid = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        this.setErrorMessage(this.errorMessage);
        if (this.errorMessage != null) {
            this.setPageComplete(false);
        }
        return isValid;
    }

    protected boolean validatePage() {
        return this.errorMessage == null && location != null && !location.isEmpty() && profileName != null && !profileName.isEmpty();
    }

    public String queryOverwrite(String pathString) {
        String message = NLS.bind((String)Messages.MfgToolImportWizard_existsQuestion, (Object)pathString);
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), "", null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }
}

