/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool.ui;

import com.freescale.mfgtool.Activator;
import com.freescale.mfgtool.Messages;
import com.freescale.mfgtool.ui.PreferenceSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class Perspective
implements IPerspectiveFactory {
    protected static final String PERSPECTIVE_ID = "com.freescale.mfgtool.ui.perspective";
    protected static final String PERSPECTIVE_LABEL = Messages.Perspective_Name;

    public void createInitialLayout(IPageLayout layout) {
        layout.addView("org.eclipse.ui.navigator.ProjectExplorer", 1, 0.25f, layout.getEditorArea());
        layout.addView("com.freescale.mfgtool.ui.multipanel", 2, 0.25f, layout.getEditorArea());
        layout.addView("com.freescale.mfgtool.ui.configuration", 3, 0.66f, "com.freescale.mfgtool.ui.multipanel");
        layout.setEditorAreaVisible(false);
    }

    public static void openPerspective() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        boolean result = true;
        String pref = PreferenceSettings.getPerspectiveSwitchSetting();
        if ("never".equals(pref)) {
            return;
        }
        if ("prompt".equals(pref)) {
            String message = NLS.bind((String)Messages.Perspective_SwitchMessage, (Object)PERSPECTIVE_LABEL);
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)workbench.getActiveWorkbenchWindow().getShell(), (String)Messages.Perspective_SwitchDialogTitle, (String)message, null, (boolean)false, (IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)"switchPerspectiveOnImport");
            boolean bl = result = dialog.getReturnCode() == 2;
            if (dialog.getToggleState()) {
                PreferenceSettings.setPerspectiveSwitchSetting(result);
            }
        }
        if (result) {
            try {
                workbench.showPerspective(PERSPECTIVE_ID, workbench.getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                Activator.log(4, Messages.Perspective_ErrorMessage, e.getCause());
            }
            return;
        }
    }
}

