/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool.ui;

import com.freescale.mfgtool.Messages;
import com.freescale.mfgtool.TwoWaySerialComm;
import com.freescale.mfgtool.ui.DeviceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.part.ViewPart;

public class Multipanel
extends ViewPart {
    public static final String VIEW_ID = "com.freescale.mfgtool.ui.multipanel";
    private int numDev = 4;
    private Composite panels;
    private DeviceSection[] sections;
    private String[] portNames;
    private List<TwoWaySerialComm> serialPorts;
    private Composite portComposite;
    private Composite composite_status_information;
    private Group grpStatusinformation;
    private Label portLabel;
    private Label successfulOps;
    private Label failedOps;
    private Label failureRate;

    public void createPartControl(Composite parent) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayout((Layout)new FillLayout());
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        final Composite outerComposite = new Composite((Composite)sc, 0);
        outerComposite.setLayout((Layout)new GridLayout(2, false));
        this.serialPorts = new ArrayList<TwoWaySerialComm>();
        this.composite_status_information = new Composite(outerComposite, 0);
        this.composite_status_information.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        RowLayout rl_composite_status_information = new RowLayout(512);
        rl_composite_status_information.fill = true;
        rl_composite_status_information.wrap = false;
        rl_composite_status_information.center = true;
        this.composite_status_information.setLayout((Layout)rl_composite_status_information);
        this.grpStatusinformation = new Group(this.composite_status_information, 0);
        this.grpStatusinformation.setText(Messages.Multipanel_StatusInformation);
        this.grpStatusinformation.setLayout((Layout)new GridLayout(2, true));
        Label lblSuccessfulOperation = new Label((Composite)this.grpStatusinformation, 0);
        lblSuccessfulOperation.setText(Messages.Multipanel_SuccessfulOperations);
        this.successfulOps = new Label((Composite)this.grpStatusinformation, 0);
        this.successfulOps.setText("0            ");
        Label lblFailedOperations = new Label((Composite)this.grpStatusinformation, 0);
        lblFailedOperations.setText(Messages.Multipanel_FailedOperations);
        this.failedOps = new Label((Composite)this.grpStatusinformation, 0);
        this.failedOps.setText("0            ");
        Label lblFailureRate = new Label((Composite)this.grpStatusinformation, 0);
        lblFailureRate.setText(Messages.Multipanel_FailureRate);
        this.failureRate = new Label((Composite)this.grpStatusinformation, 0);
        this.failureRate.setText("0 %          ");
        this.portLabel = new Label((Composite)this.grpStatusinformation, 0);
        this.portLabel.setText(Messages.Multipanel_SerialPort);
        this.portComposite = new Composite((Composite)this.grpStatusinformation, 0);
        RowLayout portLayout = new RowLayout(256);
        portLayout.fill = true;
        portLayout.wrap = true;
        portLayout.center = true;
        this.portComposite.setLayout((Layout)portLayout);
        this.portNames = TwoWaySerialComm.listSerialPorts();
        final ComboViewer portViewerCombo = new ComboViewer(this.portComposite);
        portViewerCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        portViewerCombo.setInput((Object)this.portNames);
        final Button portButton = new Button(this.portComposite, 0);
        portButton.setText(Messages.Multipanel_OpenPort);
        portButton.setVisible(false);
        portViewerCombo.getCombo().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                String[] temp = TwoWaySerialComm.listSerialPorts();
                if (!Arrays.asList(temp).equals(Arrays.asList(Multipanel.this.portNames))) {
                    Multipanel.this.portNames = temp;
                    portViewerCombo.setInput((Object)Multipanel.this.portNames);
                    portViewerCombo.refresh();
                }
                if (Multipanel.this.portNames.length == 0) {
                    portButton.setVisible(false);
                }
            }
        });
        portViewerCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                String portName = (String)selection.getFirstElement();
                if (portName == null || portName.isEmpty()) {
                    portButton.setVisible(false);
                    return;
                }
                portButton.setVisible(true);
                if (TwoWaySerialComm.isOpen(portName)) {
                    portButton.setText(Messages.Multipanel_OpenPort);
                } else {
                    portButton.setText(Messages.Multipanel_ClosePort);
                }
            }
        });
        portButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)portViewerCombo.getSelection();
                String portName = (String)selection.getFirstElement();
                if (portButton.getText().equals(Messages.Multipanel_OpenPort)) {
                    TwoWaySerialComm temp = Multipanel.this.showSerialCommConsole(portName);
                    if (temp == null) {
                        return;
                    }
                    Multipanel.this.serialPorts.add(temp);
                    portButton.setText(Messages.Multipanel_ClosePort);
                } else {
                    TwoWaySerialComm temp = null;
                    for (TwoWaySerialComm port : Multipanel.this.serialPorts) {
                        if (!port.getName().toLowerCase().contains(portName.toLowerCase())) continue;
                        temp = port;
                        break;
                    }
                    if (temp != null) {
                        temp.closePort();
                        Multipanel.this.serialPorts.remove(temp);
                    }
                    portButton.setText(Messages.Multipanel_OpenPort);
                }
            }
        });
        this.panels = new Composite(outerComposite, 0);
        this.panels.setLayout((Layout)new RowLayout(256));
        this.panels.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.sections = new DeviceSection[this.numDev];
        int i = 0;
        while (i < this.numDev) {
            this.sections[i] = new DeviceSection(this.panels);
            ++i;
        }
        sc.setContent((Control)outerComposite);
        sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = sc.getClientArea();
                sc.setMinSize(outerComposite.computeSize(r.width, -1));
            }
        });
        this.enabledConsole(true);
        this.setDeviceSectionsEnabled(false);
    }

    protected void updateSelection(int newNumDev) {
        this.numDev = newNumDev;
        int i = 0;
        while (i < this.sections.length) {
            this.sections[i].dispose();
            ++i;
        }
        this.sections = new DeviceSection[this.numDev];
        i = 0;
        while (i < this.numDev) {
            this.sections[i] = new DeviceSection(this.panels);
            ++i;
        }
        this.panels.layout(true);
        this.setDeviceSectionsEnabled(false);
    }

    public void setFocus() {
    }

    protected TwoWaySerialComm showSerialCommConsole(String name) {
        TwoWaySerialComm retval = new TwoWaySerialComm();
        IOConsole console = retval.initConsole(name);
        if (console == null) {
            MessageBox dialog = new MessageBox(Display.getDefault().getActiveShell(), 33);
            dialog.setText(Messages.Multipanel_ErrorOpenConosle);
            dialog.setMessage(String.valueOf(Messages.Multipanel_ErrorMessageCouldNotOpen) + name + ".");
            dialog.open();
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String id = "org.eclipse.ui.console.ConsoleView";
        IConsoleView view = null;
        try {
            view = (IConsoleView)page.showView(id);
            view.display((IConsole)console);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return retval;
    }

    public void enabledConsole(boolean val) {
        this.portComposite.setVisible(val);
        this.portLabel.setVisible(val);
        if (this.serialPorts.size() == 0) {
            return;
        }
        if (!val) {
            this.serialPorts.clear();
            TwoWaySerialComm.closeAll();
        } else {
            this.serialPorts.clear();
            TwoWaySerialComm.closeAll();
            this.serialPorts = new ArrayList<TwoWaySerialComm>();
            this.portNames = TwoWaySerialComm.listSerialPorts();
        }
        this.portComposite.redraw();
    }

    public void dispose() {
        try {
            TwoWaySerialComm.closeAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Multipanel openMultipanelView() {
        Multipanel retval = (Multipanel)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(VIEW_ID);
        if (retval == null) {
            try {
                retval = (Multipanel)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(VIEW_ID);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop((IWorkbenchPart)retval);
            }
            catch (PartInitException e) {
                Logger logger = Logger.getAnonymousLogger();
                logger.log(Level.SEVERE, Messages.Configuration_ErrorMessageMultipanelView, e);
                e.printStackTrace();
            }
        }
        return retval;
    }

    public void resetUI() {
        this.successfulOps.setText("0");
        this.failedOps.setText("0");
        this.failureRate.setText("0 %");
        int i = 0;
        while (i < this.sections.length) {
            this.sections[i].text.setText("");
            this.sections[i].text.redraw();
            this.sections[i].progressBar.setSelection(0);
            this.sections[i].progressBar.redraw();
            this.sections[i].text.setText("");
            this.sections[i].text.redraw();
            this.sections[i].setlblDeviceConnected("");
            this.sections[i].lblNewLabel.setText("");
            this.sections[i].text.setText("");
            ++i;
        }
        this.setDeviceSectionsEnabled(false);
    }

    public void setDeviceSectionsEnabled(boolean enabled) {
        int i = 0;
        while (i < this.sections.length) {
            this.sections[i].setEnabled(enabled);
            ++i;
        }
    }

    public void setSuccesfulOps(int number) {
        this.successfulOps.setText(Integer.toString(number));
    }

    public void setFailedOps(int number) {
        this.failedOps.setText(Integer.toString(number));
    }

    public void setFailureRate(int rate) {
        this.failureRate.setText(String.valueOf(Integer.toString(rate)) + "%");
    }

    public DeviceSection getDeviceSection(int index) {
        if (index >= this.sections.length || index < 0) {
            return null;
        }
        return this.sections[index];
    }
}

