/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool.ui;

import com.freescale.mfgtool.Command;
import com.freescale.mfgtool.CommandList;
import com.freescale.mfgtool.DeviceChangeNotifier;
import com.freescale.mfgtool.Messages;
import com.freescale.mfgtool.ProgressUpdater;
import com.freescale.mfgtool.SettingsMaker;
import com.freescale.mfgtool.ToolConfiguration;
import com.freescale.mfgtool.mfgtoollib.LibHandle;
import com.freescale.mfgtool.mfgtoollib.MfgToolLib;
import com.freescale.mfgtool.mfgtoollib.OperationInformation;
import com.freescale.mfgtool.mfgtoollib.PhaseInformation;
import com.freescale.mfgtool.ui.DeviceSection;
import com.freescale.mfgtool.ui.Multipanel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Configuration
extends ViewPart {
    public static final String VIEW_ID = "com.freescale.mfgtool.ui.configuration";
    protected static final String SAVE_CONFIGURATION = Messages.Configuration_SaveConfiguration;
    protected static final String START_OPERATION = Messages.Configuration_Start;
    protected static final String PAUSE_OPERATION = Messages.Configuration_Pause;
    protected static final String RESUME_OPERATION = Messages.Configuration_Resume;
    protected static final String CANCEL_OPERATION = Messages.Configuration_Cancel;
    protected static final String FINISH_OPERATION = Messages.Configuration_Finish;
    private String[] numDevicesList = new String[]{"1", "2", "3", "4"};
    private String[] commandOptions;
    public String[] profileOptions;
    private String[] projectOptions;
    private String[] scriptOptions;
    protected String numDevices;
    protected String profileLocation = null;
    protected String profileParentDirectory = null;
    protected ArrayList<CommandList> commandList;
    protected Combo projectCombo;
    protected Combo commandCombo;
    protected Combo profileCombo;
    protected Combo scriptCombo;
    protected TableViewer commandTableViewer;
    protected Table commandTable;
    protected File currentUCL;
    protected String currentList;
    protected Combo comboNumDevices;
    protected Button saveButton;
    protected Button startButton;
    protected Button cancelButton;
    protected Button consoleEnabled;
    protected TableViewer tviewer;
    protected SettingsMaker settingMaker;
    protected STATES state = STATES.INITIAL;
    public boolean done;
    private LibHandle handle = null;
    private MfgToolLib lib = null;
    protected String profile = null;
    protected String storage = null;
    public int currentNumDevices;
    protected VariableList uclKeywords = new VariableList();
    private OperationInformation[] opInfoArray;
    private PhaseInformation[] phaseInfoArray;
    public int[] portNumbers;
    public long[] operationID;
    public int[] phaseCommands;
    public int[] singlePhaseCommands;
    private int totalCommandNumber;
    protected Multipanel multiView;
    public Hashtable<Long, Boolean> statusID = new Hashtable();

    protected Combo createComboSelection(Composite parent, String str) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        label.setText(String.valueOf(str) + ": ");
        Combo combo = new Combo(parent, 8);
        GridData gdata = new GridData(4, 0x1000000, true, false, 1, 1);
        combo.setLayoutData((Object)gdata);
        return combo;
    }

    public void createPartControl(Composite parent) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setLayout((Layout)new GridLayout(2, false));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite outerComposite = new Composite((Composite)sc, 0);
        outerComposite.setLayout(parent.getLayout());
        final Composite uiComposite = new Composite(outerComposite, 0);
        uiComposite.setLayout((Layout)new GridLayout(2, false));
        uiComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.projectCombo = this.createComboSelection(uiComposite, Messages.Configuration_ProjectSelectorLabel);
        this.projectOptions = new String[]{Messages.Configuration_None};
        this.projectCombo.setItems(this.projectOptions);
        this.projectCombo.setEnabled(true);
        this.projectCombo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Configuration.this.updateProjectOptions();
            }
        });
        this.projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Configuration.this.projectCombo.getText().equals(Messages.Configuration_None)) {
                    Configuration.this.profileCombo.setEnabled(false);
                    Configuration.this.showMessage(Messages.Configuration_Error, Messages.Configuration_ErrorMessageNoProjects);
                    return;
                }
                Configuration.this.profileCombo.setEnabled(true);
                String temp = Configuration.this.profileParentDirectory;
                if (temp != null && temp.endsWith(Configuration.this.projectCombo.getText())) {
                    return;
                }
                Configuration.this.profileLocation = ResourcesPlugin.getWorkspace().getRoot().getProject(Configuration.this.projectCombo.getText()).getFolder(Messages.General_DefaultProfileName).getLocation().toOSString();
                if (Configuration.this.profileLocation == null || Configuration.this.profileLocation.isEmpty()) {
                    Configuration.this.showMessage(Messages.Configuration_ErrorInvalidConfiguration, Messages.Configuration_ErrorNotValid);
                    return;
                }
                int i = Configuration.this.profileLocation.lastIndexOf(String.valueOf(File.separator) + Messages.General_DefaultProfileName);
                Configuration.this.profileParentDirectory = Configuration.this.profileLocation.substring(0, i);
                Configuration.this.updateProfileOptions();
                Configuration.this.profile = null;
                Configuration.this.profileCombo.select(0);
                Configuration.this.profileCombo.notifyListeners(13, new Event());
                Configuration.this.enableButtons();
            }
        });
        this.profileCombo = this.createComboSelection(uiComposite, Messages.Configuration_ProfileSelectorLabel);
        this.profileOptions = new String[]{Messages.Configuration_None};
        this.profileCombo.setItems(this.profileOptions);
        this.profileCombo.setEnabled(false);
        this.profileCombo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Configuration.this.updateProfileOptions();
            }
        });
        this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Configuration.this.profileLocation == null) {
                    Configuration.this.showMessage(Messages.Configuration_ProfileSelectorError, Messages.Configuration_ErrorProjectUnselected);
                    Configuration.this.profile = null;
                    Configuration.this.enableUI(false);
                    return;
                }
                if (Configuration.this.profileCombo.getText().equals(Messages.Configuration_None)) {
                    Configuration.this.showMessage(Messages.Configuration_ProfileSelectorError, Messages.Configuration_ErrorMessageEmptyProfilesFolder);
                    Configuration.this.profile = null;
                    Configuration.this.enableUI(false);
                    return;
                }
                if (Configuration.this.profile != null && Configuration.this.profile.equals(Configuration.this.profileCombo.getText())) {
                    Configuration.this.enableUI(true);
                    return;
                }
                Configuration.this.profile = Configuration.this.profileCombo.getText();
                String xmlPath = String.valueOf(Configuration.this.profileLocation) + File.separator + Configuration.this.profile + File.separator + Messages.General_UCLFileParentDirectory + File.separator + Messages.General_UCLFileName;
                File temp = new File(xmlPath);
                if (!temp.exists()) {
                    Configuration.this.showMessage(Messages.Configuration_ProfileSelectorError, Messages.Configuration_ErrorMessageInvalidProfileMissingXML);
                    Configuration.this.enableUI(false);
                    return;
                }
                if (Configuration.this.updateConfigutationSettings(xmlPath)) {
                    Configuration.this.enableUI(true);
                    Configuration.this.enableButtons();
                } else {
                    Configuration.this.enableUI(false);
                    Configuration.this.profile = null;
                    Configuration.this.enableButtons();
                }
            }
        });
        this.scriptCombo = this.createComboSelection(uiComposite, Messages.Configuration_ScriptSelectorLabel);
        this.scriptOptions = new String[]{Messages.Configuration_None};
        this.scriptCombo.setItems(this.scriptOptions);
        this.scriptCombo.setEnabled(false);
        this.scriptCombo.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Configuration.this.updateScriptOptions();
            }
        });
        this.scriptCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Configuration.this.profileLocation == null || Configuration.this.projectCombo.getSelectionIndex() == -1) {
                    Configuration.this.showMessage(Messages.Configuration_SelectionError, Messages.Configuration_SelectScript);
                    return;
                }
                if (Configuration.this.profile == null || Configuration.this.profileCombo.getSelectionIndex() == -1) {
                    Configuration.this.showMessage(Messages.Configuration_SelectionError, Messages.Configuration_SelectProject);
                    return;
                }
                if (Configuration.this.scriptCombo.getText().equals(Messages.Configuration_None)) {
                    Configuration.this.enableUI(true);
                    ArrayList<Variable> varlist = new ArrayList<Variable>();
                    Map<String, String> temp = Configuration.this.settingMaker.getBaseUCLKeywords();
                    for (Map.Entry<String, String> curr : temp.entrySet()) {
                        if (curr.getKey().equals("")) continue;
                        varlist.add(new Variable(curr.getKey(), curr.getValue()));
                    }
                    int i = 0;
                    while (i < 10) {
                        varlist.add(new Variable("", ""));
                        ++i;
                    }
                    Configuration.this.uclKeywords.setList(varlist);
                    Configuration.this.tviewer.setInput((Object)Configuration.this.uclKeywords);
                } else {
                    Configuration.this.loadScript(Configuration.this.scriptCombo.getText());
                }
                Configuration.this.enableButtons();
            }
        });
        final ScrolledComposite sctemp = new ScrolledComposite(uiComposite, 2816);
        sctemp.setExpandHorizontal(true);
        sctemp.setExpandVertical(false);
        sctemp.setLayout((Layout)new GridLayout(1, true));
        sctemp.setEnabled(true);
        sctemp.setMinSize(uiComposite.computeSize(5, 5));
        final Composite tableComposite = new Composite((Composite)sctemp, 0);
        tableComposite.setEnabled(true);
        tableComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        tableComposite.setVisible(true);
        sctemp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        sc.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                tableComposite.setSize(sctemp.getSize().x, sc.getSize().y - 240);
            }
        });
        TableColumnLayout layout = new TableColumnLayout();
        tableComposite.setLayout((Layout)layout);
        sctemp.setContent((Control)tableComposite);
        this.tviewer = new TableViewer(tableComposite, 68352);
        Table table1 = this.tviewer.getTable();
        table1.setVisible(true);
        table1.setHeaderVisible(true);
        table1.setLinesVisible(true);
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tviewer, 0);
        TableColumn tblclmnFirst = tableViewerColumn_1.getColumn();
        layout.setColumnData((Widget)tblclmnFirst, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        tblclmnFirst.setText(Messages.Configuration_Variable);
        this.tviewer.setLabelProvider((IBaseLabelProvider)new CTableLabelProvider());
        this.tviewer.setContentProvider((IContentProvider)new CTableContentProvider());
        tableViewerColumn_1.setEditingSupport((EditingSupport)new ConfigurationSettingVariableEditingSupport(this.tviewer));
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tviewer, 0);
        TableColumn tblclmnLast = tableViewerColumn_2.getColumn();
        layout.setColumnData((Widget)tblclmnLast, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        tblclmnLast.setText(Messages.Configuration_Value);
        this.tviewer.setLabelProvider((IBaseLabelProvider)new CTableLabelProvider());
        this.tviewer.setContentProvider((IContentProvider)new CTableContentProvider());
        tableViewerColumn_2.setEditingSupport((EditingSupport)new ConfigurationSettingValueEditingSupport(this.tviewer));
        ArrayList<Variable> varlist = new ArrayList<Variable>();
        int i = 0;
        while (i < 5) {
            varlist.add(new Variable("", ""));
            ++i;
        }
        this.uclKeywords.setList(varlist);
        this.tviewer.setInput((Object)this.uclKeywords);
        Label commandLabel = new Label(uiComposite, 0);
        commandLabel.setText(Messages.Configuration_CommandSelectorLabel);
        this.commandCombo = new Combo(uiComposite, 8);
        GridData gdCommand = new GridData(4, 0x1000000, true, false, 1, 1);
        this.commandCombo.setLayoutData((Object)gdCommand);
        this.commandOptions = new String[]{Messages.Configuration_SDCard};
        this.commandCombo.setItems(this.commandOptions);
        this.commandCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Configuration.this.updateCommandTable();
                Configuration.this.enableButtons();
            }
        });
        Label numDevicesLabel = new Label(uiComposite, 0);
        numDevicesLabel.setText(Messages.Configuration_NumberDevicesSelectorLabel);
        this.comboNumDevices = new Combo(uiComposite, 8);
        this.comboNumDevices.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboNumDevices.setItems(this.numDevicesList);
        this.comboNumDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Configuration.this.numDevices = Configuration.this.comboNumDevices.getText();
                Configuration.this.currentNumDevices = Integer.parseInt(Configuration.this.numDevices);
                Configuration.this.multiView = Multipanel.openMultipanelView();
                if (Configuration.this.multiView == null) {
                    Configuration.this.showMessage(Messages.Configuration_ErrorMultipanelView, Messages.Configuration_ErrorMessageMultipanelView);
                    return;
                }
                Configuration.this.multiView.updateSelection(Configuration.this.currentNumDevices);
                Configuration.this.enableButtons();
            }
        });
        ComboViewer cViewer = new ComboViewer(this.comboNumDevices);
        cViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        cViewer.setInput((Object)this.numDevicesList);
        this.getSite().setSelectionProvider((ISelectionProvider)cViewer);
        this.enableUI(false);
        this.saveButton = new Button(uiComposite, 0);
        this.saveButton.setText(SAVE_CONFIGURATION);
        GridData gdButton = new GridData(4, 128, true, false, 1, 2);
        gdButton.horizontalSpan = 1;
        this.saveButton.setLayoutData((Object)gdButton);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Configuration.this.runSaveConfigurationDialog();
            }
        };
        this.saveButton.addSelectionListener((SelectionListener)adapter);
        this.done = false;
        final Job job = new Job("My MfgTool Job"){

            protected IStatus run(IProgressMonitor monitor) {
                while (!this.hasMoreWorkToDo()) {
                    if (Configuration.this.state == STATES.RESET) {
                        Configuration.this.state = STATES.INITIAL;
                        String temp = Configuration.this.stopOperation();
                        if (!temp.isEmpty()) {
                            Configuration.this.showMessage(Messages.Configuration_ErrorOperation, String.valueOf(Messages.Configuration_ErrorMessageOperationStop) + "\n" + temp);
                        }
                        Configuration.this.unitializeOperation();
                        return Status.OK_STATUS;
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private boolean hasMoreWorkToDo() {
                return Configuration.this.done;
            }
        };
        this.startButton = new Button(uiComposite, 0);
        this.startButton.setText(START_OPERATION);
        this.startButton.setEnabled(true);
        gdButton = new GridData(4, 0x1000000, true, false, 500000, 1);
        gdButton.horizontalSpan = 1;
        this.startButton.setLayoutData((Object)gdButton);
        SelectionAdapter adapterStarter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Configuration.this.startButton.getText().equals(START_OPERATION)) {
                    if (!Configuration.this.validateConfig().equals("")) {
                        Configuration.this.showMessage(Messages.Configuration_ErrorInvalidConfiguration, Configuration.this.validateConfig());
                        return;
                    }
                    Configuration.this.multiView = Multipanel.openMultipanelView();
                    if (Configuration.this.multiView == null) {
                        Configuration.this.showMessage(Messages.Configuration_ErrorMultipanelView, Messages.Configuration_ErrorMessageMultipanelView);
                        return;
                    }
                    Configuration.this.multiView.setDeviceSectionsEnabled(true);
                    String temp = Configuration.this.initializeOperation();
                    if (!temp.isEmpty()) {
                        if (temp.equals(Messages.Configuration_ErrorMessageUCLParseFail)) {
                            Configuration.this.showMessage(Messages.Configuration_ErrorInitializaton, String.valueOf(Messages.Configuration_ErrorMessageUCLParseFail) + "\n" + Messages.Configuration_ErrorMessageUCLKeywords);
                        } else {
                            Configuration.this.showMessage(Messages.Configuration_ErrorOperation, String.valueOf(Messages.Configuration_ErrorMessageOperationNotStart) + "\n" + temp);
                            Configuration.this.state = STATES.INITIAL;
                            Configuration.this.startButton.setText(START_OPERATION);
                            job.cancel();
                            Configuration.this.unitializeOperation();
                        }
                        return;
                    }
                    temp = Configuration.this.startOperation();
                    if (!temp.isEmpty()) {
                        Configuration.this.showMessage(Messages.Configuration_ErrorOperation, String.valueOf(Messages.Configuration_ErrorMessageOperationNotStart) + "\n" + temp);
                        Configuration.this.state = STATES.INITIAL;
                        Configuration.this.startButton.setText(START_OPERATION);
                        job.cancel();
                        Configuration.this.unitializeOperation();
                        return;
                    }
                    Configuration.this.state = STATES.RUNNING_OP;
                    Configuration.this.startButton.setText(PAUSE_OPERATION);
                } else if (Configuration.this.startButton.getText().equals(PAUSE_OPERATION)) {
                    String temp = Configuration.this.stopOperation();
                    if (!temp.isEmpty()) {
                        Configuration.this.showMessage(Messages.Configuration_ErrorOperation, String.valueOf(Messages.Configuration_ErrorMessageOperationStop) + "\n" + temp);
                        Configuration.this.state = STATES.INITIAL;
                        Configuration.this.startButton.setText(START_OPERATION);
                        job.cancel();
                        Configuration.this.unitializeOperation();
                        return;
                    }
                    Configuration.this.state = STATES.PAUSED_OP;
                    Configuration.this.startButton.setText(RESUME_OPERATION);
                    Configuration.this.cancelButton.setEnabled(true);
                } else if (Configuration.this.startButton.getText().equals(RESUME_OPERATION)) {
                    String temp = Configuration.this.startOperation();
                    if (!temp.isEmpty()) {
                        Configuration.this.showMessage(Messages.Configuration_ErrorOperation, String.valueOf(Messages.Configuration_ErrorMessageOperationNotStart) + "\n" + temp);
                        Configuration.this.startButton.setText(START_OPERATION);
                        Configuration.this.cancelButton.setEnabled(false);
                        Configuration.this.state = STATES.INITIAL;
                        job.cancel();
                        Configuration.this.unitializeOperation();
                        return;
                    }
                    Configuration.this.startOperation();
                    Configuration.this.state = STATES.RUNNING_OP;
                    Configuration.this.startButton.setText(PAUSE_OPERATION);
                    Configuration.this.cancelButton.setEnabled(false);
                } else if (Configuration.this.startButton.getText().equals(FINISH_OPERATION)) {
                    job.done(null);
                    Configuration.this.unitializeOperation();
                    Configuration.this.state = STATES.INITIAL;
                    Configuration.this.startButton.setText(START_OPERATION);
                    Configuration.this.resetUI();
                }
            }
        };
        this.startButton.addSelectionListener((SelectionListener)adapterStarter);
        this.cancelButton = new Button(uiComposite, 0);
        this.cancelButton.setText(CANCEL_OPERATION);
        this.cancelButton.setEnabled(false);
        gdButton = new GridData(4, 0x1000000, true, false, 500000, 1);
        gdButton.horizontalSpan = 1;
        this.cancelButton.setLayoutData((Object)gdButton);
        SelectionAdapter adapterCanceler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String temp = Configuration.this.unitializeOperation();
                if (!temp.isEmpty()) {
                    Configuration.this.showMessage(Messages.Configuration_ErrorCancel, temp);
                }
                Configuration.this.startButton.setText(START_OPERATION);
                Configuration.this.state = STATES.INITIAL;
                Configuration.this.cancelButton.setEnabled(false);
                Configuration.this.resetUI();
            }
        };
        this.cancelButton.addSelectionListener((SelectionListener)adapterCanceler);
        Composite xmlComposite = new Composite(outerComposite, 0);
        xmlComposite.setLayout((Layout)new FillLayout(256));
        this.commandTableViewer = new TableViewer(xmlComposite, 2816);
        this.commandTable = this.commandTableViewer.getTable();
        this.commandTable.setHeaderVisible(true);
        this.commandTable.setLinesVisible(true);
        int columnwidth = xmlComposite.getBounds().width;
        if (columnwidth <= 0) {
            columnwidth = 300;
        }
        TableColumn tblclmnType = new TableColumn(this.commandTable, 0);
        tblclmnType.setWidth(columnwidth / 3);
        tblclmnType.setText(Messages.Configuration_Type);
        TableColumn tblclmnCMD = new TableColumn(this.commandTable, 0);
        tblclmnCMD.setWidth(columnwidth / 3);
        tblclmnCMD.setText(Messages.Configuration_Command);
        TableColumn tblclmnDescription = new TableColumn(this.commandTable, 0);
        tblclmnDescription.setWidth(columnwidth / 3);
        tblclmnDescription.setText(Messages.Configuration_Description);
        sc.setContent((Control)outerComposite);
        sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = sc.getClientArea();
                Point p = uiComposite.computeSize(r.width, -1);
                sc.setMinSize(p);
                sc.update();
            }
        });
        this.enableButtons();
    }

    protected void enableButtons() {
        String temp = this.validateConfig();
        if (temp.isEmpty()) {
            this.startButton.setEnabled(true);
            this.saveButton.setEnabled(true);
        } else {
            this.startButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        }
        this.startButton.update();
        this.saveButton.update();
    }

    protected void updateScriptOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (this.settingMaker != null) {
            SettingsMaker temp;
            List<String> tempOptions;
            options.addAll(Arrays.asList(this.settingMaker.getScriptOptions()));
            if (this.profile != null && this.profileLocation != null && this.commandOptions != null && !(tempOptions = Arrays.asList((temp = new SettingsMaker(this.profileLocation, this.profile, Arrays.asList(this.commandOptions))).getScriptOptions())).equals(options)) {
                options = new ArrayList<String>(tempOptions);
            }
            Collections.sort(options);
            options.add(0, Messages.Configuration_None);
        } else {
            options = new ArrayList();
            options.add(Messages.Configuration_None);
        }
        if (options.equals(Arrays.asList(this.scriptCombo.getItems()))) {
            return;
        }
        String[] toSet = new String[options.size()];
        toSet = options.toArray(toSet);
        this.scriptCombo.setItems(toSet);
        this.scriptCombo.update();
    }

    protected void updateProjectOptions() {
        String[] temp = this.getProjectOptions();
        if (this.projectOptions == null || !Arrays.asList(temp).equals(Arrays.asList(this.projectOptions))) {
            this.projectOptions = temp;
            this.projectCombo.setItems(this.projectOptions);
            this.projectCombo.update();
            this.enableUI(false);
            this.profileCombo.setEnabled(false);
            this.projectCombo.update();
        }
    }

    private String[] getProjectOptions() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> projectNames = new ArrayList<String>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IFolder path = project.getFolder(Messages.General_DefaultProfileName);
            if (path.exists() && project.isAccessible()) {
                String tmp = project.getName();
                projectNames.add(tmp);
            }
            ++n2;
        }
        if (projectNames.isEmpty()) {
            return new String[]{Messages.Configuration_None};
        }
        String[] retval = new String[projectNames.size()];
        retval = projectNames.toArray(retval);
        return retval;
    }

    protected void runSaveConfigurationDialog() {
        Display display = Display.getCurrent();
        Shell shell = new Shell(display);
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText(Messages.Configuration_Save);
        fd.setFileName(Messages.Configuration_DefaultSaveFileName);
        String temp = this.profileParentDirectory;
        if (temp == null || temp.equals(Messages.Configuration_None)) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            File workspaceDirectory = workspace.getRoot().getLocation().toFile();
            temp = workspaceDirectory.getPath();
        }
        fd.setFilterPath(temp);
        String[] filterExt = new String[]{Messages.General_VBSFileEnding, "."};
        fd.setFilterExtensions(filterExt);
        String selected = fd.open();
        this.saveScript(selected);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void saveScript(String location) {
        ToolConfiguration toSave = new ToolConfiguration(this.profile, this.storage, this.uclKeywords.getMap());
        boolean success = this.settingMaker.saveVBSScript(toSave, location);
        if (!success) {
            this.showMessage(Messages.Configuration_ErrorSaveFile, Messages.Configuration_ErrorMessageFileSaveFail);
        }
    }

    protected void loadScript(String name) {
        int i;
        ToolConfiguration loaded = this.settingMaker.getConfiguration(name);
        if (loaded == null) {
            this.showMessage(Messages.Configuration_Error, String.valueOf(Messages.Configuration_ErrorMessageInvalidConfiguration) + "\n" + name);
            return;
        }
        HashMap<String, String> temp = loaded.getAllUclKeywords();
        ArrayList<Variable> templist = new ArrayList<Variable>();
        if (temp != null) {
            templist = new ArrayList();
            for (Map.Entry curr : temp.entrySet()) {
                if (((String)curr.getKey()).equals("")) continue;
                templist.add(new Variable((String)curr.getKey(), (String)curr.getValue()));
            }
            i = 0;
            while (i < 10) {
                templist.add(new Variable("", ""));
                ++i;
            }
        } else {
            templist = new ArrayList();
            i = 0;
            while (i < 15) {
                templist.add(new Variable("", ""));
                ++i;
            }
        }
        this.uclKeywords.setList(templist);
        this.tviewer.setInput((Object)this.uclKeywords);
        this.tviewer.refresh();
        this.storage = loaded.getStorage();
        String commandList = loaded.getStorage();
        String[] options = this.commandCombo.getItems();
        i = 0;
        while (i < options.length) {
            if (options[i].equalsIgnoreCase(commandList)) break;
            ++i;
        }
        if (i >= options.length) {
            this.showMessage(Messages.Configuration_ErrorLoading, String.valueOf(Messages.Configuration_ErrorMessageInvalidConfiguration) + "\n" + commandList + Messages.Configuration_ErrorMessageNotValidSelection);
            return;
        }
        this.commandCombo.select(i);
        this.updateCommandTable();
        this.currentNumDevices = 1;
        this.comboNumDevices.select(this.currentNumDevices - 1);
        this.multiView = Multipanel.openMultipanelView();
        if (this.multiView == null) {
            this.showMessage(Messages.Configuration_ErrorMultipanelView, Messages.Configuration_ErrorMessageMultipanelView);
            return;
        }
        this.multiView.updateSelection(this.currentNumDevices);
        this.enableUI(true);
    }

    public void enableUI(boolean val) {
        if (this.scriptCombo != null) {
            this.scriptCombo.setEnabled(val);
        }
        if (this.comboNumDevices != null) {
            this.comboNumDevices.setEnabled(val);
        }
        if (this.commandCombo != null) {
            this.commandCombo.setEnabled(val);
        }
        if (this.consoleEnabled != null) {
            this.consoleEnabled.setEnabled(val);
        }
        if (this.tviewer != null) {
            this.tviewer.getTable().setEnabled(val);
        }
    }

    public void dispose() {
        if (this.handle != null) {
            this.lib.destroyLibHandle(this.handle);
            this.handle = null;
        }
    }

    public void setFocus() {
    }

    public boolean updateConfigutationSettings(String xmlPath) {
        if (xmlPath == null) {
            return false;
        }
        this.commandList = new ArrayList();
        this.currentUCL = new File(xmlPath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        String error = null;
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(this.currentUCL);
            doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException e) {
            error = e.getMessage();
        }
        catch (SAXException e) {
            error = e.getMessage();
        }
        catch (IOException e) {
            error = e.getMessage();
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        if (error != null) {
            this.showMessage(Messages.Configuration_ErrorUCLParsing, String.valueOf(Messages.Configuration_ErrorMessageUCLFileInvalid) + "\n" + error);
            return false;
        }
        NodeList nList = doc.getElementsByTagName(Messages.Configuration_UCLFileLIST);
        this.commandOptions = new String[nList.getLength()];
        int temp = 0;
        while (temp < nList.getLength()) {
            Node nNode = nList.item(temp);
            if (nNode.getNodeType() == 1) {
                Element eElement = (Element)nNode;
                CommandList l = new CommandList();
                l.setName(eElement.getAttribute("name"));
                l.setDescription(eElement.getAttribute("desc"));
                NodeList internalList = eElement.getElementsByTagName(Messages.Configuration_UCLFileCMD);
                int temp1 = 0;
                while (temp1 < internalList.getLength()) {
                    Node iNode = internalList.item(temp1);
                    if (iNode.getNodeType() == 1) {
                        Element iElement = (Element)iNode;
                        l.addToList(iElement.getAttribute("state"), iElement.getAttribute("type"), iElement.getAttribute("body"), iElement.getTextContent());
                    }
                    ++temp1;
                }
                this.commandList.add(l);
                this.commandOptions[temp] = eElement.getAttribute("name");
            }
            ++temp;
        }
        this.commandCombo.setItems(this.commandOptions);
        this.state = STATES.INITIAL;
        this.settingMaker = new SettingsMaker(this.profileLocation, this.profile, Arrays.asList(this.commandOptions));
        this.updateScriptOptions();
        return true;
    }

    public void updateProfileOptions() {
        File file = new File(this.profileLocation);
        String[] names = file.list();
        ArrayList<String> options = new ArrayList<String>();
        if (names == null || names.length == 0) {
            options.add(Messages.Configuration_None);
        } else {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (new File(String.valueOf(this.profileLocation) + File.separator + name).isDirectory()) {
                    options.add(name);
                }
                ++n2;
            }
        }
        List<String> currentOptions = Arrays.asList(this.profileOptions);
        if (currentOptions.equals(options)) {
            return;
        }
        this.profileOptions = options.toArray(new String[options.size()]);
        this.profileCombo.setItems(this.profileOptions);
        this.profileCombo.update();
    }

    protected void updateCommandTable() {
        for (CommandList l : this.commandList) {
            if (!this.commandCombo.getText().equals(l.getName())) continue;
            this.currentList = l.getName();
            this.commandTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            this.commandTableViewer.setContentProvider((IContentProvider)new TableContentProvider());
            this.commandTableViewer.setInput((Object)l);
        }
    }

    protected String initializeOperation() {
        block9: {
            this.portNumbers = new int[this.currentNumDevices];
            this.phaseCommands = new int[this.currentNumDevices];
            this.operationID = new long[this.currentNumDevices];
            this.singlePhaseCommands = new int[1];
            int i = 0;
            while (i < this.portNumbers.length) {
                this.portNumbers[i] = -1;
                this.operationID[i] = -1L;
                this.phaseCommands[i] = -1;
                ++i;
            }
            try {
                this.lib = MfgToolLib.getInstance();
                this.lib.registerJNIObjects();
                this.handle = this.lib.createLibHandle();
                this.lib.setProfilePath(this.handle, this.profileParentDirectory);
                this.lib.setProfileName(this.handle, this.profile);
                this.lib.setListName(this.handle, this.storage);
                this.lib.setMaxBoardNumber(this.handle, this.currentNumDevices);
                ArrayList<Variable> temp = this.uclKeywords.getList();
                for (Variable curr : temp) {
                    if (curr.getName().equals("")) continue;
                    this.lib.setUCLKeyword(curr.getName(), curr.getValue());
                }
            }
            catch (Exception e) {
                return e.getMessage();
            }
            try {
                this.lib.initializeOperation(this.handle);
            }
            catch (Exception e) {
                if (!e.getMessage().contains("4")) break block9;
                return Messages.Configuration_ErrorMessageUCLParseFail;
            }
        }
        this.multiView = Multipanel.openMultipanelView();
        if (this.multiView == null) {
            return String.valueOf(Messages.Configuration_ErrorMultipanelView) + Messages.Configuration_ErrorMessageMultipanelView;
        }
        try {
            this.opInfoArray = this.lib.getOperationInformation(this.handle);
            this.phaseInfoArray = this.lib.getPhaseInformation(this.handle);
            this.totalCommandNumber = this.phaseInfoArray[this.phaseInfoArray.length - 1].getPhaseCommandNumbers();
            this.lib.registerCallback(this.handle, 0, new DeviceChangeNotifier(this.portNumbers, this.operationID, this.multiView));
            this.lib.registerCallback(this.handle, 1, new ProgressUpdater(this.operationID, this.totalCommandNumber, this.multiView, this));
            this.printOpInfo(this.opInfoArray);
            this.singlePhaseCommands[0] = this.lib.getTotalCommandNumbers(this.handle);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    protected String startOperation() {
        try {
            this.opInfoArray = this.lib.getOperationInformation(this.handle);
            this.printOpInfo(this.opInfoArray);
            OperationInformation[] operationInformationArray = this.opInfoArray;
            int n = this.opInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                OperationInformation current = operationInformationArray[n2];
                this.lib.startOperation(this.handle, current.getOperationID());
                ++n2;
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    protected String stopOperation() {
        OperationInformation[] operationInformationArray = this.opInfoArray;
        int n = this.opInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            OperationInformation current = operationInformationArray[n2];
            try {
                this.lib.stopOperation(this.handle, current.getOperationID());
            }
            catch (Exception e) {
                e.getMessage().contains("25");
                return Messages.Configuration_ErrorMessageOperationCompromised;
            }
            ++n2;
        }
        return "";
    }

    protected String unitializeOperation() {
        block3: {
            try {
                this.lib.unregisterCallback(this.handle, 0);
                this.lib.unregisterCallback(this.handle, 1);
                if (!System.getProperty("os.name").contains("nux")) break block3;
                this.lib.destroyLibHandle(this.handle);
                return "";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        this.lib.uninitializeOperation(this.handle);
        this.lib.uninitialize();
        this.lib.destroyLibHandle(this.handle);
        this.handle = null;
        return "";
    }

    public void setOperationAsFinished() {
        this.startButton.setText(FINISH_OPERATION);
        this.startButton.setEnabled(true);
        this.state = STATES.FINISHED_OP;
    }

    public void setOperationAsRunning() {
        this.startButton.setText(PAUSE_OPERATION);
        this.startButton.setEnabled(true);
        this.state = STATES.RUNNING_OP;
    }

    private void printOpInfo(OperationInformation[] opInfoArray) {
        int i = 0;
        while (i < opInfoArray.length) {
            int portIndex = -1;
            int n = 0;
            while (n < this.portNumbers.length) {
                if (opInfoArray[i].getPortIndex() == this.portNumbers[n]) {
                    portIndex = n;
                    break;
                }
                if (this.portNumbers[n] == -1 || this.portNumbers[n] == 0) {
                    portIndex = n;
                    this.portNumbers[n] = opInfoArray[i].getPortIndex();
                    this.operationID[n] = opInfoArray[i].getOperationID();
                    this.statusID.put(opInfoArray[i].getOperationID(), false);
                    break;
                }
                ++n;
            }
            final int opCount = i++;
            final int port = portIndex;
            final OperationInformation[] opInfo = opInfoArray;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (opInfo[opCount].isConnected()) {
                        Configuration.this.multiView = Multipanel.openMultipanelView();
                        if (Configuration.this.multiView == null) {
                            Configuration.this.showMessage(Messages.Configuration_ErrorMultipanelView, Messages.Configuration_ErrorMessageMultipanelView);
                            return;
                        }
                        DeviceSection deviceSection = Configuration.this.multiView.getDeviceSection(port);
                        deviceSection.setlblDeviceConnected(opInfo[opCount].getDeviceDesc());
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(6));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.setSectionTitle(String.valueOf(Messages.Multipanel_Port) + " " + opInfo[opCount].getPortIndex());
                    }
                }
            });
        }
    }

    public String validateConfig() {
        if (this.projectCombo.getSelectionIndex() == -1) {
            return Messages.Configuration_SelectProject;
        }
        if (this.profileCombo.getSelectionIndex() == -1) {
            return Messages.Configuration_SelectProfile;
        }
        if (this.scriptCombo.getSelectionIndex() == -1) {
            return Messages.Configuration_SelectScript;
        }
        if (this.commandCombo.getSelectionIndex() == -1) {
            return Messages.Configuration_SelectCommandList;
        }
        if (this.comboNumDevices.getSelectionIndex() == -1) {
            return Messages.Configuration_SelectNumberDevices;
        }
        return "";
    }

    public void resetUI() {
        this.multiView = (Multipanel)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.freescale.mfgtool.ui.multipanel");
        this.multiView.resetUI();
    }

    protected void showMessage(String title, String msg) {
        MessageBox dialog = new MessageBox(Display.getDefault().getActiveShell(), 33);
        dialog.setText(title);
        dialog.setMessage(msg);
        dialog.open();
    }

    public int getTotalCommandNumber() {
        return this.totalCommandNumber;
    }

    private static class CTableContentProvider
    implements IStructuredContentProvider {
        private CTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            VariableList w = (VariableList)inputElement;
            return w.getList().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class CTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CTableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = ((Variable)element).getName();
                    break;
                }
                case 1: {
                    result = ((Variable)element).getValue();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private class ConfigurationSettingValueEditingSupport
    extends EditingSupport {
        private ColumnViewer myViewer;
        private CellEditor myCellEditor;

        public ConfigurationSettingValueEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.myViewer = viewer;
            this.myCellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.myCellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((Variable)element).getValue();
        }

        protected void setValue(Object element, Object value) {
            ((Variable)element).setValue((String)value);
            this.getViewer().update(element, null);
        }

        public ColumnViewer getViewer() {
            return this.myViewer;
        }
    }

    private class ConfigurationSettingVariableEditingSupport
    extends EditingSupport {
        private ColumnViewer myViewer;
        private CellEditor myCellEditor;

        public ConfigurationSettingVariableEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.myViewer = viewer;
            this.myCellEditor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.myCellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((Variable)element).getName();
        }

        protected void setValue(Object element, Object value) {
            ((Variable)element).setName((String)value);
            this.getViewer().update(element, null);
        }

        public ColumnViewer getViewer() {
            return this.myViewer;
        }
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1, boolean var2);
    }

    public static enum STATES {
        INITIAL,
        VALID_CONFIGURATION,
        INITIALIZE_TOOL,
        RUNNING_OP,
        PAUSED_OP,
        FINISHED_OP,
        CANCELLED_OP,
        RESET;

    }

    private static class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            CommandList w = (CommandList)inputElement;
            return w.getList().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            Command c = (Command)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = c.getType();
                    break;
                }
                case 1: {
                    result = c.getCMD();
                    break;
                }
                case 2: {
                    result = c.getValue();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    private class Variable {
        private String name;
        private String value;

        public Variable(String variable, String value) {
            this.name = variable;
            this.value = value;
        }

        public void setName(String variable) {
            this.name = variable;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isEqual(Variable that) {
            return this.getName().equals(that.getName()) && this.getValue().equals(that.getValue());
        }

        public boolean hasSameVariable(String name) {
            return this.getName().equals(name);
        }
    }

    private class VariableList {
        ArrayList<Variable> list = new ArrayList();

        public ArrayList<Variable> getList() {
            return this.list;
        }

        public void setList(ArrayList<Variable> list) {
            this.list = list;
        }

        public String getValue(String name) {
            for (Variable curr : this.list) {
                if (!curr.hasSameVariable(name)) continue;
                return curr.getValue();
            }
            return null;
        }

        public boolean setValue(String variable, String value) {
            for (Variable curr : this.list) {
                if (!curr.hasSameVariable(variable)) continue;
                curr.setValue(value);
                return true;
            }
            return false;
        }

        public boolean contains(String name) {
            for (Variable curr : this.list) {
                if (!curr.hasSameVariable(name)) continue;
                return true;
            }
            return false;
        }

        public void add(String variable, String value) {
            Variable temp = new Variable(variable, value);
            this.list.add(temp);
        }

        public Map<String, String> getMap() {
            HashMap<String, String> retval = new HashMap<String, String>();
            for (Variable var : this.list) {
                retval.put(var.getName(), var.getValue());
            }
            return retval;
        }
    }
}

