/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool.mfgtoollib;

import com.freescale.mfgtool.Messages;
import com.freescale.mfgtool.mfgtoollib.Callback;
import com.freescale.mfgtool.mfgtoollib.LibHandle;
import com.freescale.mfgtool.mfgtoollib.OperationInformation;
import com.freescale.mfgtool.mfgtoollib.PhaseInformation;
import java.io.File;

public class MfgToolLib {
    public static final int MIN_DEVICES = 1;
    public static final int MAX_DEVICES = 4;
    public static final int CALLBACK_TYPE_DEVICE_CHANGE_NOTIFIER = 0;
    public static final int CALLBACK_TYPE_PROGRESS_UPDATER = 1;
    private static MfgToolLib inst;

    static {
        try {
            System.loadLibrary("MfgToolLib");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(String.valueOf(Messages.General_NativeCodeLibLoadFail) + e);
            try {
                System.loadLibrary("libMfgToolLib");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println(String.valueOf(Messages.General_NativeCodeLibLoadFail) + e);
            }
        }
    }

    public static native String getLibraryVersion();

    public static synchronized MfgToolLib getInstance() {
        if (inst == null) {
            inst = new MfgToolLib();
        }
        return inst;
    }

    public void uninitialize() {
        this._uninitialize();
        inst = null;
    }

    public native void registerJNIObjects();

    public LibHandle createLibHandle() {
        return new LibHandle();
    }

    public void destroyLibHandle(LibHandle handle) {
        this._destroyLibHandle(handle.getHandle());
    }

    public void setProfileName(LibHandle handle, String name) {
        this._setProfileName(handle.getHandle(), name);
    }

    public void setListName(LibHandle handle, String name) {
        this._setListName(handle.getHandle(), name);
    }

    public void setUCLFile(LibHandle handle, String name) {
        this._setUCLFile(handle.getHandle(), name);
    }

    public void setMaxBoardNumber(LibHandle handle, int boardNum) {
        this._setMaxBoardNumber(handle.getHandle(), boardNum);
    }

    public void initializeOperation(LibHandle handle) {
        this._initializeOperation(handle.getHandle());
    }

    public void uninitializeOperation(LibHandle handle) {
        this._uninitializeOperation(handle.getHandle());
    }

    public long getOperationID(LibHandle handle, int index) {
        return this._getOperationID(handle.getHandle(), index);
    }

    public void startOperation(LibHandle handle, long operationID) {
        this._startOperation(handle.getHandle(), operationID);
    }

    public void stopOperation(LibHandle handle, long operationID) {
        this._stopOperation(handle.getHandle(), operationID);
    }

    public OperationInformation[] getOperationInformation(LibHandle handle) {
        OperationInformation[] retval = new OperationInformation[1];
        retval = this._getOperationInformation(handle.getHandle());
        return retval;
    }

    public PhaseInformation[] getPhaseInformation(LibHandle handle) {
        PhaseInformation[] retval = null;
        retval = this._getPhaseInformation(handle.getHandle());
        return retval;
    }

    public int getTotalCommandNumbers(LibHandle handle) {
        return this._getTotalCommandNumbers(handle.getHandle());
    }

    public void registerCallback(LibHandle handle, int callbackType, Callback callme) {
        this._registerCallback(handle.getHandle(), callbackType, callme);
    }

    public void unregisterCallback(LibHandle handle, int callbackType) {
        this._unregisterCallback(handle.getHandle(), callbackType);
    }

    public native int getCount();

    public void setUCLKeyword(String key, String value) {
        this._setUCLKeyword(key, value);
    }

    public void setProfilePath(LibHandle handle, String newpath) {
        if (!newpath.endsWith(File.separator)) {
            this._setProfilePath(handle.getHandle(), String.valueOf(newpath) + File.separator);
        } else {
            this._setProfilePath(handle.getHandle(), newpath);
        }
    }

    private MfgToolLib() {
        this.initialize();
    }

    private native void initialize();

    private native void _uninitialize();

    private native void _destroyLibHandle(long var1);

    private native void _setProfileName(long var1, String var3);

    private native void _setListName(long var1, String var3);

    private native void _setUCLFile(long var1, String var3);

    private native void _setMaxBoardNumber(long var1, int var3);

    private native void _initializeOperation(long var1);

    private native void _uninitializeOperation(long var1);

    private native void _startOperation(long var1, long var3);

    private native void _stopOperation(long var1, long var3);

    private native OperationInformation[] _getOperationInformation(long var1);

    private native PhaseInformation[] _getPhaseInformation(long var1);

    private native int _getTotalCommandNumbers(long var1);

    private native void _registerCallback(long var1, int var3, Callback var4);

    private native void _unregisterCallback(long var1, int var3);

    private native long _getOperationID(long var1, int var3);

    private native void _setUCLKeyword(String var1, String var2);

    private native void _setProfilePath(long var1, String var3);
}

