/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool;

import com.freescale.mfgtool.Messages;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class TwoWaySerialComm {
    private static final int BAUD_RATE = 115200;
    private IOConsole console = null;
    protected IOConsoleOutputStream out = null;
    private SerialPort serialPort = null;
    private static Hashtable<IOConsole, SerialPort> openPorts = new Hashtable();

    static {
        try {
            System.loadLibrary("rxtxSerial");
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(String.valueOf(Messages.General_NativeCodeLibLoadFail) + e);
        }
    }

    public synchronized IOConsole initConsole(String name) {
        if (name == null) {
            return null;
        }
        this.console = this.openConsole(name);
        this.out = this.console.newOutputStream();
        String com = name;
        try {
            this.connect(com);
            return this.console;
        }
        catch (Exception exception) {
            this.disconnect();
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            conMan.removeConsoles(new IConsole[]{this.console});
            return null;
        }
    }

    private IOConsole openConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (IOConsole)existing[i];
            }
            ++i;
        }
        IOConsole newConsole = new IOConsole(name, null);
        conMan.addConsoles(new IConsole[]{newConsole});
        return newConsole;
    }

    public static String[] listSerialPorts() {
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        ArrayList<String> portList = new ArrayList<String>();
        String[] portArray = null;
        while (ports.hasMoreElements()) {
            CommPortIdentifier port = (CommPortIdentifier)ports.nextElement();
            if (port.getPortType() != 1) continue;
            portList.add(port.getName());
        }
        portArray = portList.toArray(new String[0]);
        return portArray;
    }

    public static boolean isOpen(String name) {
        CommPortIdentifier portIdentifier;
        try {
            portIdentifier = CommPortIdentifier.getPortIdentifier((String)name);
        }
        catch (NoSuchPortException e) {
            Logger logger = Logger.getAnonymousLogger();
            logger.log(Level.SEVERE, Messages.Configuration_ErrorMessageMultipanelView, e);
            return false;
        }
        return !portIdentifier.isCurrentlyOwned();
    }

    private synchronized void connect(String portName) throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier((String)portName);
        if (portIdentifier.isCurrentlyOwned()) {
            return;
        }
        CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
        if (commPort instanceof SerialPort) {
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(115200, 8, 1, 0);
            InputStream in = this.serialPort.getInputStream();
            OutputStream out = this.serialPort.getOutputStream();
            new Thread(new SerialWriter(out, this.console.getInputStream())).start();
            this.serialPort.addEventListener((SerialPortEventListener)new SerialReader(in));
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.notifyOnBreakInterrupt(true);
            this.serialPort.enableReceiveTimeout(100);
            openPorts.put(this.console, this.serialPort);
        }
    }

    public static synchronized void closeAll() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        List<IConsole> existing = Arrays.asList(conMan.getConsoles());
        ArrayList<IConsole> toRemove = new ArrayList<IConsole>();
        for (Map.Entry<IOConsole, SerialPort> port : openPorts.entrySet()) {
            port.getValue().removeEventListener();
            port.getValue().sendBreak(2000);
            port.getValue().close();
            int ind = existing.indexOf(port.getKey());
            if (ind == -1) continue;
            toRemove.add(existing.get(ind));
        }
        IConsole[] temp = new IConsole[toRemove.size()];
        conMan.removeConsoles(toRemove.toArray(temp));
        openPorts.clear();
    }

    public synchronized void closePort() {
        if (this.serialPort != null) {
            this.serialPort.removeEventListener();
            this.serialPort.sendBreak(2000);
            this.serialPort.close();
        }
        if (this.console != null) {
            if (openPorts.containsKey(this.console)) {
                openPorts.get(this.console).removeEventListener();
                this.serialPort.sendBreak(2000);
                openPorts.get(this.console).close();
                openPorts.remove(this.console);
            }
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            conMan.removeConsoles(new IConsole[]{this.console});
        }
        this.serialPort = null;
        this.console = null;
    }

    protected synchronized void disconnect() {
        try {
            this.out.close();
        }
        catch (IOException e1) {
            Logger logger = Logger.getAnonymousLogger();
            logger.log(Level.SEVERE, Messages.Configuration_ErrorMessageMultipanelView, e1);
            return;
        }
        if (this.serialPort != null) {
            this.serialPort.close();
        }
    }

    public synchronized String getName() {
        return this.console.getName();
    }

    private class SerialReader
    implements SerialPortEventListener {
        private InputStream in;
        private byte[] buffer = new byte[1024];

        public SerialReader(InputStream in) {
            this.in = in;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void serialEvent(SerialPortEvent arg0) {
            try {
                int data;
                int len = 0;
                if (this.in == null) {
                    return;
                }
                while ((data = this.in.read()) > -1 && data != 10) {
                    this.buffer[len++] = (byte)data;
                }
                TwoWaySerialComm.this.out.write(new String(this.buffer, 0, len));
                return;
            }
            catch (IOException e) {
                TwoWaySerialComm.this.disconnect();
                Logger logger = Logger.getAnonymousLogger();
                logger.log(Level.SEVERE, Messages.Configuration_ErrorMessageMultipanelView, e);
                e.printStackTrace();
                return;
            }
        }
    }

    private class SerialWriter
    implements Runnable {
        OutputStream out;
        IOConsoleInputStream toOutput;

        public SerialWriter(OutputStream out, IOConsoleInputStream toOutput) {
            this.out = out;
            this.toOutput = toOutput;
        }

        @Override
        public synchronized void run() {
            try {
                int c = 0;
                while ((c = this.toOutput.read()) > -1) {
                    this.out.write(c);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

