/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ToolConfiguration
implements Serializable {
    private static final long serialVersionUID = -7516371931852715041L;
    private String profile;
    private String storage;
    private HashMap<String, String> uclKeywords;

    public ToolConfiguration(String profile, String storage, Map<String, String> uclKeywords) {
        this.profile = profile;
        this.storage = storage;
        this.uclKeywords = (HashMap)uclKeywords;
    }

    public ToolConfiguration() {
        this.uclKeywords = new HashMap();
    }

    public boolean equals(ToolConfiguration that) {
        if (!this.getProfile().equals(that.getProfile())) {
            return false;
        }
        if (!this.getStorage().equals(that.getStorage())) {
            return false;
        }
        return this.getAllUclKeywords().equals(that.getAllUclKeywords());
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public HashMap<String, String> getAllUclKeywords() {
        return this.uclKeywords;
    }

    public void setAllUclKeywords(Map<String, String> uclKeywords) {
        this.uclKeywords = (HashMap)uclKeywords;
    }

    public String getUCLKeyword(String name) {
        return this.getAllUclKeywords().get(name);
    }

    public void setUCLKeyword(String name, String value) {
        this.getAllUclKeywords().put(name, value);
    }

    public void addUclKeywords(Map<String, String> newKeywords) {
        for (String key : newKeywords.keySet()) {
            if (this.uclKeywords.containsKey(key)) continue;
            this.uclKeywords.put(key, newKeywords.get(key));
        }
    }
}

