/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool;

import com.freescale.mfgtool.Messages;
import com.freescale.mfgtool.ToolConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class SettingsMaker {
    private String profilesLocation;
    private String profileName;
    private List<String> storageOptions;
    private Hashtable<String, ToolConfiguration> parsedScripts;
    private Map<String, String> baseKeywords;
    private ArrayList<String> fileNames;

    public String[] getScriptOptions() {
        if (this.fileNames == null || this.fileNames.isEmpty()) {
            return new String[0];
        }
        return this.fileNames.toArray(new String[this.fileNames.size()]);
    }

    private void parseScripts() {
        String str = this.profilesLocation;
        int ind = str.lastIndexOf(String.valueOf(File.separator) + "Profiles");
        if (ind != -1) {
            str = str.substring(0, ind);
        }
        this.profilesLocation = str;
        ArrayList<String> allFileNames = this.recordVBSFileNames();
        this.fileNames = new ArrayList();
        for (String fileName : allFileNames) {
            ToolConfiguration curr = this.getConfigurationFromVBS(fileName);
            if (curr == null || !curr.getProfile().equalsIgnoreCase(this.profileName) || this.storageOptions != null && !this.storageOptions.contains(curr.getStorage())) continue;
            this.parsedScripts.put(new String(fileName), curr);
            this.fileNames.add(fileName);
        }
        Collections.sort(this.fileNames);
    }

    public static Map<String, String> getUCLKeywordsFromCfgIni(String path) {
        HashMap<String, String> retval = new HashMap<String, String>();
        if (path == null) {
            throw new NullPointerException();
        }
        File cfg = new File(path);
        if (!(cfg.exists() && cfg.isFile() && cfg.getPath().endsWith("cfg.ini"))) {
            throw new IllegalArgumentException();
        }
        Scanner sc = null;
        try {
            try {
                String tmp;
                sc = new Scanner(cfg);
                while (sc.hasNextLine()) {
                    tmp = sc.nextLine();
                    if (tmp.toLowerCase().contains("variable")) break;
                }
                while (sc.hasNextLine()) {
                    tmp = sc.nextLine();
                    int ind = tmp.indexOf("=");
                    String key = tmp.substring(0, ind).replace("=", "").trim();
                    String val = tmp.substring(ind, tmp.length()).replace("=", "").trim();
                    retval.put(key, val);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException();
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return retval;
    }

    private ToolConfiguration getConfigurationFromVBS(String fileName) {
        ToolConfiguration retval = new ToolConfiguration();
        retval.addUclKeywords(this.baseKeywords);
        File script = new File(String.valueOf(this.profilesLocation) + File.separator + fileName);
        Scanner sc = null;
        try {
            try {
                sc = new Scanner(script);
                while (sc.hasNext()) {
                    String tmp;
                    String input = sc.next();
                    if (input == null) {
                        break;
                    }
                    if (input.equals("-c")) {
                        input = sc.next();
                        while (!input.endsWith("\"\"")) {
                            tmp = sc.next();
                            input = input.concat(" " + tmp);
                        }
                        input = input.replaceAll("\"", "");
                        retval.setProfile(input);
                    }
                    if (input.equals("-l")) {
                        input = sc.next();
                        while (!input.endsWith("\"\"")) {
                            tmp = sc.next();
                            input = input.concat(" " + tmp);
                        }
                        input = input.replaceAll("\"", "");
                        retval.setStorage(input);
                    }
                    if (!input.equals("-s")) continue;
                    input = sc.next();
                    while (!input.endsWith("\"\"")) {
                        tmp = sc.next();
                        input = input.concat(" " + tmp);
                    }
                    input = input.replaceAll("\"", "");
                    int ind = input.indexOf("=");
                    String key = input.substring(0, ind);
                    String val = input.substring(ind + 1);
                    retval.setUCLKeyword(key, val);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (sc != null) {
                    sc.close();
                }
                return null;
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        if (retval.getProfile() == null || retval.getStorage() == null) {
            return null;
        }
        return retval;
    }

    public static ToolConfiguration getConfigurationFromVBS(String script, String cfg) {
        ToolConfiguration retval = new ToolConfiguration();
        retval.addUclKeywords(SettingsMaker.getUCLKeywordsFromCfgIni(cfg));
        Scanner sc = null;
        try {
            try {
                sc = new Scanner(new File(script));
                while (sc.hasNext()) {
                    String tmp;
                    String input = sc.next();
                    if (input == null) {
                        break;
                    }
                    if (input.equals("-c")) {
                        input = sc.next();
                        while (!input.endsWith("\"\"")) {
                            tmp = sc.next();
                            input = input.concat(" " + tmp);
                        }
                        input = input.replaceAll("\"", "");
                        retval.setProfile(input);
                    }
                    if (input.equals("-l")) {
                        input = sc.next();
                        while (!input.endsWith("\"\"")) {
                            tmp = sc.next();
                            input = input.concat(" " + tmp);
                        }
                        input = input.replaceAll("\"", "");
                        retval.setStorage(input);
                    }
                    if (!input.equals("-s")) continue;
                    input = sc.next();
                    while (!input.endsWith("\"\"")) {
                        tmp = sc.next();
                        input = input.concat(" " + tmp);
                    }
                    input = input.replaceAll("\"", "");
                    int ind = input.indexOf("=");
                    String key = input.substring(0, ind);
                    String val = input.substring(ind + 1);
                    retval.setUCLKeyword(key, val);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                ToolConfiguration toolConfiguration = retval;
                if (sc != null) {
                    sc.close();
                }
                return toolConfiguration;
            }
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return retval;
    }

    private ArrayList<String> recordVBSFileNames() {
        File folder = new File(this.profilesLocation);
        File[] listOfFiles = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(Messages.General_VBSFileEnding);
            }
        });
        ArrayList<String> retval = new ArrayList<String>();
        int i = 0;
        while (i < listOfFiles.length) {
            if (listOfFiles[i].isFile() && listOfFiles[i].canRead()) {
                String name = listOfFiles[i].getName();
                retval.add(name);
            }
            ++i;
        }
        return retval;
    }

    public SettingsMaker(String profilesParentDirectory, String profileName, List<String> storageOptions) {
        String str = profilesParentDirectory;
        int ind = str.lastIndexOf(String.valueOf(File.separator) + Messages.General_DefaultProfileName);
        if (ind != -1) {
            str = str.substring(0, ind);
        }
        this.profilesLocation = str;
        try {
            this.baseKeywords = SettingsMaker.getUCLKeywordsFromCfgIni(String.valueOf(this.profilesLocation) + File.separator + Messages.General_ConfigFile);
        }
        catch (Exception exception) {
            this.baseKeywords = new HashMap<String, String>();
        }
        this.profileName = profileName;
        this.fileNames = new ArrayList();
        this.parsedScripts = new Hashtable();
        this.parseScripts();
    }

    public String getProfilesLocation() {
        return this.profilesLocation;
    }

    public void setProfilesLocation(String profilesLocation) {
        this.profilesLocation = profilesLocation;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public Map<String, String> getBaseUCLKeywords() {
        return this.baseKeywords;
    }

    public ToolConfiguration getConfiguration(String name) {
        if (this.parsedScripts.containsKey(name)) {
            return this.parsedScripts.get(name);
        }
        return null;
    }

    public boolean saveVBSScript(ToolConfiguration toSave, String location) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(location), "utf-8"));
            writer.write("Set wshShell = CreateObject(\"WScript.shell\")\n");
            writer.write("wshShell.run \"mfgtool2.exe");
            if (toSave.getProfile() != null) {
                writer.write(" -c \"\"" + toSave.getProfile() + "\"\"");
            }
            if (toSave.getStorage() != null) {
                writer.write(" -l \"\"" + toSave.getStorage() + "\"\"");
            }
            HashMap<String, String> keywords = toSave.getAllUclKeywords();
            for (Map.Entry entry : keywords.entrySet()) {
                if (this.baseKeywords.containsKey(entry.getKey()) && this.baseKeywords.get(entry.getKey()).equals(entry.getValue()) || entry.getKey() == null || ((String)entry.getKey()).equals("")) continue;
                if (entry.getValue() == null) {
                    entry.setValue("");
                }
                writer.write(" -s \"\"" + (String)entry.getKey() + "=" + (String)entry.getValue() + "\"\"");
            }
            writer.write(" \"\n");
            writer.write("Set wshShell = Nothing");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

