/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool;

import com.freescale.mfgtool.Messages;
import com.freescale.mfgtool.mfgtoollib.Callback;
import com.freescale.mfgtool.mfgtoollib.OperateResultInfo;
import com.freescale.mfgtool.ui.Configuration;
import com.freescale.mfgtool.ui.DeviceSection;
import com.freescale.mfgtool.ui.Multipanel;
import org.eclipse.swt.widgets.Display;

public class ProgressUpdater
implements Callback {
    private long[] opID;
    protected Multipanel multiView;
    protected Configuration configView;
    protected int totalCommands;
    protected int successful_op = 0;
    protected int fail_op = 0;

    public ProgressUpdater() {
    }

    public ProgressUpdater(long[] opID, int totalCommands, Multipanel multiView, Configuration configView) {
        this.opID = opID;
        this.multiView = multiView;
        this.totalCommands = totalCommands;
        this.configView = configView;
    }

    @Override
    public synchronized void execute(Object info) {
        final OperateResultInfo opInfo = (OperateResultInfo)info;
        int i = 0;
        i = 0;
        while (i < this.opID.length) {
            if (this.opID[i] == opInfo.getOperationID()) break;
            ++i;
        }
        final int operationID = i;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DeviceSection deviceSection = ProgressUpdater.this.multiView.getDeviceSection(operationID);
                if (opInfo.getCmdInfo().toLowerCase().indexOf(Messages.ProgressUpdater_Error) == -1 || opInfo.getCmdStatus() != 2) {
                    deviceSection.text.setForeground(Display.getCurrent().getSystemColor(2));
                    deviceSection.text.redraw();
                    deviceSection.progressBar.setForeground(Display.getCurrent().getSystemColor(5));
                    deviceSection.progressBar.setBackground(Display.getCurrent().getSystemColor(5));
                    deviceSection.progressBar.setState(0);
                    deviceSection.progressBar.redraw();
                } else {
                    ++ProgressUpdater.this.fail_op;
                    ProgressUpdater.this.multiView.setFailedOps(ProgressUpdater.this.fail_op);
                    ProgressUpdater.this.configView.statusID.put(opInfo.getOperationID(), true);
                    int rate = (int)((double)((float)ProgressUpdater.this.fail_op / (float)(ProgressUpdater.this.fail_op + ProgressUpdater.this.successful_op)) * 100.0);
                    ProgressUpdater.this.multiView.setFailureRate(rate);
                    deviceSection.text.setForeground(Display.getCurrent().getSystemColor(3));
                    deviceSection.text.redraw();
                    deviceSection.progressBar.setForeground(Display.getCurrent().getSystemColor(3));
                    deviceSection.progressBar.setBackground(Display.getCurrent().getSystemColor(3));
                    deviceSection.progressBar.setState(1);
                    deviceSection.progressBar.redraw();
                }
                deviceSection.text.setText(opInfo.getCmdInfo());
                deviceSection.text.redraw();
                int progress = (int)((double)((float)opInfo.getCmdIndex() / (float)ProgressUpdater.this.totalCommands) * 100.0);
                deviceSection.progressBar.setSelection(progress);
                if (ProgressUpdater.this.configView.getTotalCommandNumber() == opInfo.getCmdIndex() && opInfo.getCmdStatus() == 1) {
                    ++ProgressUpdater.this.successful_op;
                    ProgressUpdater.this.multiView.setSuccesfulOps(ProgressUpdater.this.successful_op);
                    deviceSection.text.setForeground(Display.getCurrent().getSystemColor(6));
                    deviceSection.text.redraw();
                    deviceSection.progressBar.setSelection(100);
                    deviceSection.progressBar.setForeground(Display.getCurrent().getSystemColor(5));
                    deviceSection.progressBar.setBackground(Display.getCurrent().getSystemColor(5));
                    deviceSection.progressBar.redraw();
                    ProgressUpdater.this.configView.setOperationAsFinished();
                } else {
                    ProgressUpdater.this.configView.setOperationAsRunning();
                }
            }
        });
    }
}

