/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.mfgtool;

import com.freescale.mfgtool.Messages;
import com.freescale.mfgtool.mfgtoollib.Callback;
import com.freescale.mfgtool.mfgtoollib.DeviceChangeInfo;
import com.freescale.mfgtool.ui.DeviceSection;
import com.freescale.mfgtool.ui.Multipanel;
import org.eclipse.swt.widgets.Display;

public class DeviceChangeNotifier
implements Callback {
    private int[] portNumbers;
    protected Multipanel multiView;
    private long[] opIDs;

    public DeviceChangeNotifier() {
    }

    public DeviceChangeNotifier(int[] portNumbers, long[] opIDs, Multipanel multiView) {
        this.portNumbers = portNumbers;
        this.multiView = multiView;
        this.opIDs = opIDs;
    }

    @Override
    public synchronized void execute(Object info) {
        final DeviceChangeInfo devInfo = (DeviceChangeInfo)info;
        int i = 0;
        i = 0;
        while (i < this.portNumbers.length) {
            if (devInfo.getPortIndex() == this.portNumbers[i]) break;
            if (this.portNumbers[i] == -1 || this.portNumbers[i] == 0) {
                this.portNumbers[i] = devInfo.getPortIndex();
                this.opIDs[i] = devInfo.getOperationID();
                break;
            }
            ++i;
        }
        final int port = i;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DeviceSection deviceSection = DeviceChangeNotifier.this.multiView.getDeviceSection(port);
                switch (devInfo.getEvent()) {
                    case 0: {
                        deviceSection.setlblDeviceConnected(devInfo.getDeviceDesc());
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(6));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.lblNewLabel.setText(String.valueOf(devInfo.getDriverLetter()) + ":");
                        deviceSection.lblNewLabel.redraw();
                        deviceSection.setSectionTitle(String.valueOf(Messages.DeviceChangeNotifier_Port) + devInfo.getPortIndex());
                        deviceSection.text.setText("");
                        deviceSection.text.redraw();
                        deviceSection.progressBar.setSelection(0);
                        break;
                    }
                    case 1: {
                        deviceSection.setlblDeviceConnected(Messages.DeviceChangeNotifier_USBMassStorageDevice);
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(9));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.lblNewLabel.setText(String.valueOf(devInfo.getDriverLetter()) + ":");
                        deviceSection.lblNewLabel.redraw();
                        deviceSection.setSectionTitle(String.valueOf(Messages.DeviceChangeNotifier_Port) + devInfo.getPortIndex());
                        break;
                    }
                    case 2: {
                        deviceSection.setlblDeviceConnected(Messages.DeviceChangeNotifier_DeviceDisconnected);
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(3));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.lblNewLabel.setText("-");
                        deviceSection.lblNewLabel.redraw();
                        break;
                    }
                    case 3: {
                        deviceSection.setlblDeviceConnected("Device Disconnected");
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(3));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.lblNewLabel.setText("-");
                        deviceSection.lblNewLabel.redraw();
                        break;
                    }
                    case 4: {
                        deviceSection.setlblDeviceConnected(Messages.DeviceChangeNotifier_HUBConnected);
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(6));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.lblNewLabel.setText("-");
                        deviceSection.lblNewLabel.redraw();
                        break;
                    }
                    case 5: {
                        deviceSection.setlblDeviceConnected(Messages.DeviceChangeNotifier_HUBDisconnected);
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(3));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.lblNewLabel.setText("-");
                        deviceSection.lblNewLabel.redraw();
                        break;
                    }
                    default: {
                        deviceSection.setlblDeviceConnected(Messages.DeviceChangeNotifier_StatusUnknown);
                        deviceSection.lblDeviceConnected.setForeground(Display.getDefault().getSystemColor(3));
                        deviceSection.lblDeviceConnected.redraw();
                        deviceSection.lblNewLabel.setText("-");
                        deviceSection.lblNewLabel.redraw();
                    }
                }
            }
        });
    }
}

